/**********************************************
Cyril Vallet - 2020 - www.sciencesmania.com   
Si vous modifiez/copier ce code merci d'indiquer
la provenance en mettant un lien vers mon site  
 
Pour les montages et l'électronique voir mon site
www.sciencesmania.com  

************   1- le réglage  ***************
le fil du Guitayourt doit être au bord de la del rouge 
afin de donner un maximum de tension quand le fil occulte 
la lumière parvenant au phototransistor (typeMesure = 1)

************   2- la mesure de la durée ***************
L'AOP crée un signal carré dès qu'il détecte une tension > 250 mV
Il faut crer un signal carré car la tension ne serait pas suffisante pour
que la pin de l'arduino détecte le signal.
La mesure s'effectue après 50 ms  car la corde vient d'être tirée et 
les oscillations n'ont pas encore démarré.
Le programme est en attente d'une tension nulle puis 
au signal suivant "haut" déclenche le chronomètre et s'arrête 
au signal "haut" suivant (typeMesure = 2)

note : il est certainement possible d'utiliser les "interrupt"
pour réaliser la mesure. Si vous avez un code à partager -> mon site
**********************************************/

int donneesRecues = 0; // les données reçues provenant de la page web
int typeMesure=0; // défini le type de donnés qui sera envoyé  1 : A0 et pour le 2 : duree

int etape; // defini les étapes afin de déterminer la période comme préciser plus haut
long chrono1, chrono2, duree; // mesure du temps 

/**********************************************
               INITIALISATION       
 **********************************************/
void setup() {
  // demarrer la liaison serie à la vitesse de 115200 bauds
  Serial.begin(115200);
  // définir la connectique 2 comme une ENTREE numérique
  pinMode(2, INPUT);
  // initalisation des variables
  etape=0;
  duree=0;
  chrono1=0;
  chrono2=0;
  
} // fin du setup

/**********************************************
      Le programme qui fonctionne en boucle    
 **********************************************/
void loop() {

  //************   1- le réglage  ***************
  // envoie les mesures de la tension du phototransistor
  // à chaque itération du loop
  if (typeMesure ==1){
    Serial.println(analogRead(A0)); 
  }
  
  //************   2- la mesure de la durée ***************
  // envoie les mesures de la tension du phototransistor
  // à l'étape 4, une pause de 1500 ms est prévue pour 
  // limiter les mesures parasites
 if (typeMesure ==2){

  // déclenchement du chrono dès qu'un signal est percu
  if (etape==0 && digitalRead(2) == 1){
    chrono1 = millis();
    etape=1;
  }

  // Attente de 50 ms avant de démarrer la mesure
   if (etape>0 && (millis()- chrono1) > 50){
    
      if (etape==1 && digitalRead(2)==0){ // un niveau bas  est détecté on peut démarrer la séquence
        etape=2; 
      }
      if (etape==2 && digitalRead(2)==1) { // un niveau haut est détecté : on déclenche le chrono
        chrono2 = micros(); 
        etape=3;
        }
      if (etape==3 && digitalRead(2)==0){ // on attend qu'un niveau bas soit détecté
        etape=4;
      }
      if (etape==4 && digitalRead(2)==1) { // dès que l'autre niveau haut est détecté, on calcule la durée.
        duree = micros()- chrono2; 
        Serial.println(duree); // envoie de la duree à la page web
        etape=5;  
      }  
     if (etape==5 && (millis()-chrono1)> 1500) { // attente de 1,5 s pour éviter des mesures parasites
      etape =0;
     }
   } 
   
  }
  
} // fin du loop

/**********************************************
                 EVENEMENT SERIE      
 Une vérification de la présence de données est effectué au début du LOOP.
 Pour éviter de ralentir le programme  un SEUL octet (code ASCII) est réçu puis traité.
 **********************************************/

void serialEvent() {
  
  // si des données sont disponibles 
  while (Serial.available()) { 
    
       donneesRecues = Serial.read(); // lire les données
     // Verification de la  connexion  l'Arduino <-> page WEB
      if (donneesRecues =='g'){  // si la page web a envoyé g
         Serial.println('g');   // alors envoie g 
      }
      
      // si r est reçu, on déclenche l'envoi des données 
      // pour le réglage
      if (donneesRecues =='r'){ 
         typeMesure=1;   
      }

      // échange pour arrêter l'envoie des données
      // pour interface des mesures entre les deux étapes
      if (donneesRecues =='m'){ 
         Serial.println('m'); 
         typeMesure=0; 
      }

      // si n est reçu, on déclenche l'envoi des données pour la durée
      if (donneesRecues =='n'){ 
         typeMesure=2;  
      }   
  }
} // fin Serial Event
