/**********************************************
Cyril Vallet - 2020 - www.sciencesmania.com   
Si vous modifiez/copier ce code merci d'indiquer
la provenance en mettant un lien vers mon site  
 
Pour les montages et l'électronique voir mon site
www.sciencesmania.com  

**************************************
Ce programme envoie la valeur  numérique de la tension appliquée sur la pin A0
L'envoie se fait sur le port serie que récupère la page web via un logiciel (voir mon site)

Il repose aussi sur le fait que le temps mis pour effectuer la conversion analogique numérique est quasi constante.
En tout cas la marge d'erreur est assez faible, pour plus de détails voir ce site
https://zestedesavoir.com/billets/2068/arduino-accelerer-analogread/
***************************************/

int donneesRecues = 0; // les données reçues provenant de la page web
int echantillonnage=0; // type d'échantillon 300 sur un intervalle de temps multiple

int nbDonnees = 300; // nombre de données à mesurer
int valeur[300]; // tableau de 300 mesures
int a; // pour stocker la mesure

// modification interne de l'Arduino afin d'accélérer le CAN
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

/**********************************************
               INITIALISATION       
 **********************************************/
void setup() {

  // demarrer la liaison serie à la vitesse de 200000000 bauds
  Serial.begin(2000000);

  // Reglages de l'Arduino pour modifier la durée du CAN
  sbi(ADCSRA, ADPS2);
  cbi(ADCSRA, ADPS1);
  sbi(ADCSRA, ADPS0);
  
} // fin du setup

/**********************************************
      Le programme qui fonctionne en boucle    
      
 Les mesures sont effectuées PUIS envoyé
 sinon le SERIAL nécessite lui aussi un temps d'exécution
 **********************************************/
void loop() {
 
 if (echantillonnage ==1){ 
    for (int i=0;i<nbDonnees;i++) valeur[i]=analogRead(A0); // remplir le tableau avec la mesure
    for (int i=0;i<nbDonnees;i++) Serial.println(valeur[i]);  // envoyer les 300 valeurs
    echantillonnage =0; // pour attendre une demande d'envoie de données
 }

 if (echantillonnage ==2){ 
    for (int i=0;i<nbDonnees*2;i++){ // il faut doubler l'iteration car une valeur sur 2 sera retenue
       a = analogRead(A0); // la mesure est quand même executée pour avoir une durée constante entre les mesures
       if (i%2 == 0) valeur[i/2]=a; // une valeur sur 2 est retenue 
    }
    for (int i=0;i<nbDonnees;i++) Serial.println(valeur[i]); 
    echantillonnage =0;
 }

 if (echantillonnage ==3){ 
   for (int i=0;i<nbDonnees*4;i++){ // une valeur sur 4 est retenue 
       a = analogRead(A0);
       if (i%4 == 0) valeur[i/4]=a;
  }
  for (int i=0;i<nbDonnees;i++)  Serial.println(valeur[i]);
  echantillonnage =0;
 }

 if (echantillonnage ==4){ 
  for (int i=0;i<nbDonnees*8;i++){ // une valeur sur 8 est retenue 
       a = analogRead(A0);
       if (i%8 == 0) valeur[i/8]=a;
  }
  for (int i=0;i<nbDonnees;i++) Serial.println(valeur[i]);
  echantillonnage =0;
 }

 if (echantillonnage ==5){  // une valeur sur 16 est retenue 
  for (int i=0;i<nbDonnees*16;i++){
      a = analogRead(A0);
       if (i%16 == 0) valeur[i/16]=a;
  }
  for (int i=0;i<nbDonnees;i++) Serial.println(valeur[i]); 
  echantillonnage =0;
 }
 
} // fin du loop

/**********************************************
                 EVENEMENT SERIE      
 Une vérification de la présence de données sur le port série est effectué au début du LOOP.
 Pour éviter de ralentir le programme  un SEUL octet (code ASCII) est réçu puis traité.
 **********************************************/

void serialEvent() {
  
  while (Serial.available()) {  // si des données sont disponibles 
       donneesRecues = Serial.read(); // lire les données
       
     // Verification de la  connexion avec l'Arduino <-> page WEB
     // si on recoit de la page web la valeur  g alors on envoie g comme réponse
      if (donneesRecues =='g') Serial.println('g');  

      // quelle données envoyées ?
      if (donneesRecues =='s') echantillonnage=0; // Arret d'envoie des donnéess 
      if (donneesRecues =='r') echantillonnage=1; 
      if (donneesRecues =='t') echantillonnage=2; 
      if (donneesRecues =='u') echantillonnage=3; 
      if (donneesRecues =='v') echantillonnage=4; 
      if (donneesRecues =='w') echantillonnage=5; 
  }
} // fin Serial Event
