/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import processing.core.PApplet;
import processing.data.FloatDict;
import processing.data.IntDict;
import processing.data.JSONArray;
import processing.data.JSONTokener;
import processing.data.StringDict;

public class JSONObject {
    private static final int keyPoolSize = 100;
    private static HashMap<String, Object> keyPool = new HashMap(100);
    private final HashMap<String, Object> map = new HashMap();
    public static final Object NULL = new Null();

    public JSONObject() {
    }

    public JSONObject(Reader reader) {
        this(new JSONTokener(reader));
    }

    protected JSONObject(JSONTokener x) {
        this();
        if (x.nextClean() != '{') {
            throw new RuntimeException("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw new RuntimeException("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw new RuntimeException("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw new RuntimeException("Expected a ',' or '}'");
    }

    protected JSONObject(HashMap<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                Object value = e.getValue();
                if (value == null) continue;
                map.put(e.getKey(), JSONObject.wrap(value));
            }
        }
    }

    public JSONObject(IntDict dict) {
        int i = 0;
        while (i < dict.size()) {
            this.setInt(dict.key(i), dict.value(i));
            ++i;
        }
    }

    public JSONObject(FloatDict dict) {
        int i = 0;
        while (i < dict.size()) {
            this.setFloat(dict.key(i), dict.value(i));
            ++i;
        }
    }

    public JSONObject(StringDict dict) {
        int i = 0;
        while (i < dict.size()) {
            this.setString(dict.key(i), dict.value(i));
            ++i;
        }
    }

    protected JSONObject(Object bean) {
        this();
        this.populateMap(bean);
    }

    public static JSONObject parse(String source) {
        return new JSONObject(new JSONTokener(source));
    }

    protected static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object get(String key) {
        if (key == null) {
            throw new RuntimeException("JSONObject.get(null) called");
        }
        Object object = this.opt(key);
        if (object == null) {
            return null;
        }
        if (object == null) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] not found");
        }
        return object;
    }

    public String getString(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a string");
    }

    public String getString(String key, String defaultValue) {
        Object object = this.opt(key);
        return NULL.equals(object) ? defaultValue : object.toString();
    }

    public int getInt(String key) {
        Object object = this.get(key);
        if (object == null) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] not found");
        }
        try {
            return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not an int.");
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public long getLong(String key) {
        Object object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception e) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a long.", e);
        }
    }

    public long getLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public float getFloat(String key) {
        return (float)this.getDouble(key);
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return this.getFloat(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        Object object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a number.");
        }
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return this.getDouble(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) {
        Object object = this.get(key);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public JSONArray getJSONArray(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator keyIterator() {
        return this.map.keySet().iterator();
    }

    public Set keys() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    private static String numberToString(Number number) {
        if (number == null) {
            throw new RuntimeException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private Object opt(String key) {
        return key == null ? null : this.map.get(key);
    }

    private void populateMap(Object bean) {
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            try {
                Method method = methods[i];
                if (Modifier.isPublic(method.getModifiers())) {
                    String name = method.getName();
                    String key = "";
                    if (name.startsWith("get")) {
                        key = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                    } else if (name.startsWith("is")) {
                        key = name.substring(2);
                    }
                    if (key.length() > 0 && Character.isUpperCase(key.charAt(0)) && method.getParameterTypes().length == 0) {
                        if (key.length() == 1) {
                            key = key.toLowerCase();
                        } else if (!Character.isUpperCase(key.charAt(1))) {
                            key = String.valueOf(key.substring(0, 1).toLowerCase()) + key.substring(1);
                        }
                        Object result = method.invoke(bean, null);
                        if (result != null) {
                            this.map.put(key, JSONObject.wrap(result));
                        }
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public JSONObject setString(String key, String value) {
        return this.put(key, value);
    }

    public JSONObject setInt(String key, int value) {
        this.put(key, value);
        return this;
    }

    public JSONObject setLong(String key, long value) {
        this.put(key, value);
        return this;
    }

    public JSONObject setFloat(String key, float value) {
        this.put(key, value);
        return this;
    }

    public JSONObject setDouble(String key, double value) {
        this.put(key, value);
        return this;
    }

    public JSONObject setBoolean(String key, boolean value) {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject setJSONObject(String key, JSONObject value) {
        return this.put(key, value);
    }

    public JSONObject setJSONArray(String key, JSONArray value) {
        return this.put(key, value);
    }

    public JSONObject put(String key, Object value) {
        if (key == null) {
            throw new RuntimeException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            String pooled = (String)keyPool.get(key);
            if (pooled == null) {
                if (keyPool.size() >= 100) {
                    keyPool = new HashMap(100);
                }
                keyPool.put(key, key);
            } else {
                key = pooled;
            }
            this.map.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    private JSONObject putOnce(String key, Object value) {
        if (key != null && value != null) {
            if (this.opt(key) != null) {
                throw new RuntimeException("Duplicate key \"" + key + "\"");
            }
            this.put(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JSONObject.quote(string, sw).toString();
            }
            catch (IOException iOException) {
                return "";
            }
        }
    }

    public static Writer quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    break;
                }
                case '\b': {
                    w.write("\\b");
                    break;
                }
                case '\t': {
                    w.write("\\t");
                    break;
                }
                case '\n': {
                    w.write("\\n");
                    break;
                }
                case '\f': {
                    w.write("\\f");
                    break;
                }
                case '\r': {
                    w.write("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        break;
                    }
                    w.write(c);
                }
            }
            ++i;
        }
        w.write(34);
        return w;
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    protected static Object stringToValue(String string) {
        block10: {
            if (string.equals("")) {
                return string;
            }
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (string.equalsIgnoreCase("null")) {
                return NULL;
            }
            char b = string.charAt(0);
            if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
                try {
                    if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                        Double d = Double.valueOf(string);
                        if (!d.isInfinite() && !d.isNaN()) {
                            return d;
                        }
                        break block10;
                    }
                    Long myLong = Long.valueOf(string);
                    if (myLong == (long)myLong.intValue()) {
                        return myLong.intValue();
                    }
                    return myLong;
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    protected static void testValidity(Object o) {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new RuntimeException("JSON does not allow non-finite numbers.");
        }
    }

    public boolean save(File file, String options) {
        PrintWriter writer = PApplet.createWriter(file);
        boolean success = this.write(writer, options);
        writer.close();
        return success;
    }

    public boolean write(PrintWriter output) {
        return this.write(output, null);
    }

    public boolean write(PrintWriter output, String options) {
        int indentFactor = 2;
        if (options != null) {
            String[] opts;
            String[] stringArray = opts = PApplet.split(options, ',');
            int n = opts.length;
            int n2 = 0;
            while (n2 < n) {
                String opt = stringArray[n2];
                if (opt.equals("compact")) {
                    indentFactor = -1;
                } else if (opt.startsWith("indent=")) {
                    indentFactor = PApplet.parseInt(opt.substring(7), -2);
                    if (indentFactor == -2) {
                        throw new IllegalArgumentException("Could not read a number from " + opt);
                    }
                } else {
                    System.err.println("Ignoring " + opt);
                }
                ++n2;
            }
        }
        output.print(this.format(indentFactor));
        output.flush();
        return true;
    }

    public String toString() {
        try {
            return this.format(2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(int indentFactor) {
        StringWriter w = new StringWriter();
        StringBuffer stringBuffer = w.getBuffer();
        synchronized (stringBuffer) {
            return this.writeInternal(w, indentFactor, 0).toString();
        }
    }

    protected static String valueToString(Object value) {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JSONObject(value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray(value).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONObject.quote(value.toString());
    }

    protected static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray(object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject(object);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws IOException {
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).writeInternal(writer, indentFactor, indent);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).writeInternal(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            new JSONObject(value).writeInternal(writer, indentFactor, indent);
        } else if (value instanceof Collection) {
            new JSONArray(value).writeInternal(writer, indentFactor, indent);
        } else if (value.getClass().isArray()) {
            new JSONArray(value).writeInternal(writer, indentFactor, indent);
        } else if (value instanceof Number) {
            writer.write(JSONObject.numberToString((Number)value));
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else {
            JSONObject.quote(value.toString(), writer);
        }
        return writer;
    }

    static final void indent(Writer writer, int indent) throws IOException {
        int i = 0;
        while (i < indent) {
            writer.write(32);
            ++i;
        }
    }

    protected Writer writeInternal(Writer writer, int indentFactor, int indent) {
        try {
            int actualFactor;
            boolean commanate = false;
            int length = this.size();
            Iterator keys = this.keyIterator();
            writer.write(123);
            int n = actualFactor = indentFactor == -1 ? 0 : indentFactor;
            if (length == 1) {
                Object key = keys.next();
                writer.write(JSONObject.quote(key.toString()));
                writer.write(58);
                if (actualFactor > 0) {
                    writer.write(32);
                }
                JSONObject.writeValue(writer, this.map.get(key), indentFactor, indent);
            } else if (length != 0) {
                int newIndent = indent + actualFactor;
                while (keys.hasNext()) {
                    Object key = keys.next();
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor != -1) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newIndent);
                    writer.write(JSONObject.quote(key.toString()));
                    writer.write(58);
                    if (actualFactor > 0) {
                        writer.write(32);
                    }
                    JSONObject.writeValue(writer, this.map.get(key), indentFactor, newIndent);
                    commanate = true;
                }
                if (indentFactor != -1) {
                    writer.write(10);
                }
                JSONObject.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

