/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.serial.Serial;

public class guitayourt_processing
extends PApplet {
    Bouton boutonOkReglage;
    Bouton boutonRefaireReglage;
    Bouton boutonQuitter;
    Bouton boutonWeb;
    PFont font20;
    PFont font12;
    PFont font15;
    PFont font10;
    PFont font25;
    int etape = 0;
    long raz;
    PFont font;
    PImage imageArduino;
    PImage imageCommentGratter;
    PImage imageCourbe;
    PImage imageCourbeZero;
    PImage imageReglage;
    float periode;
    float[] tableauMesure = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    Serial maConnexionArduino;
    int etatConnexionArduino = 0;
    String messageRecu;
    int tension;

    public void setup() {
        this.font20 = this.loadFont("Arial-BoldMT-20.vlw");
        this.font25 = this.loadFont("Arial-BoldMT-25.vlw");
        this.font15 = this.loadFont("Arial-BoldMT-15.vlw");
        this.font12 = this.loadFont("Arial-BoldMT-12.vlw");
        this.font10 = this.loadFont("Arial-BoldMT-10.vlw");
        this.chargerImages();
        this.boutonOkReglage = new Bouton(750, 535, 60, 20, "Ok", "okReglageFonction", 1);
        this.boutonRefaireReglage = new Bouton(540, 50, 100, 20, "Refaire r\u00e9glage", "refaireReglageFonction", 1);
        this.boutonQuitter = new Bouton(75, 150, 60, 25, "Quitter", "quitterFonction", 1);
        this.boutonWeb = new Bouton(75, this.height - 13, 130, 25, "site", "webFonction", 2);
        this.periode = 0.0f;
        this.connexionArduino();
    }

    public void draw() {
        this.background(50);
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.fill(30);
        this.rect(0.0f, 0.0f, 150.0f, this.height);
        this.image(this.imageArduino, 20.0f, 20.0f);
        this.fill(200.0f, 200.0f, 200.0f);
        this.textFont(this.font20);
        this.text("        T.P.    \n Guitayourt", 10.0f, this.height / 2);
        this.fill(80.0f, 80.0f, 80.0f);
        this.textFont(this.font10);
        this.text(PApplet.parseInt((float)this.frameRate), 5.0f, 10.0f);
        this.boutonQuitter.represente();
        this.fill(100.0f, 100.0f, 100.0f);
        this.textFont(this.font10);
        this.text("Cyril Vallet (c) - 2020 \n www.sciencesmania.com", 5.0f, this.height - 18);
        if (this.etatConnexionArduino == -1) {
            this.pbConnexion();
        }
        if (this.etatConnexionArduino == 1) {
            this.fill(255.0f, 255.0f, 255.0f);
            this.textFont(this.font10);
            this.text("Connexion \u00e0 l'arduino ...", 25.0f, 105.0f);
            this.maConnexionArduino.write("g");
        }
        if (this.etatConnexionArduino == 2) {
            this.fill(0.0f, 255.0f, 150.0f);
            this.textFont(this.font10);
            this.text("Connect\u00e9", 25.0f, 105.0f);
        }
        if (this.etatConnexionArduino == 2 && this.etape == 0) {
            this.maConnexionArduino.write(114);
            this.etape = 1;
        }
        if (this.etatConnexionArduino == 2 && this.etape == 1) {
            this.reglage();
        }
        if (this.etatConnexionArduino == 2 && this.etape == 2) {
            this.reglage();
        }
        if (this.etatConnexionArduino == 2 && this.etape == 4) {
            this.maConnexionArduino.write(110);
            this.etape = 5;
        }
        if (this.etatConnexionArduino == 2 && this.etape == 5) {
            this.mesure();
        }
    }

    public void mouseReleased() {
        String quelleFonction = this.boutonOkReglage.checkOver();
        if (quelleFonction.equals("okReglageFonction") && this.etape == 1) {
            this.maConnexionArduino.write(109);
            this.etape = 3;
        }
        if ((quelleFonction = this.boutonRefaireReglage.checkOver()).equals("refaireReglageFonction") && this.etape == 5) {
            this.etape = 0;
        }
        if ((quelleFonction = this.boutonWeb.checkOver()).equals("webFonction")) {
            this.link("https://www.sciencesmania.com");
        }
        if ((quelleFonction = this.boutonQuitter.checkOver()).equals("quitterFonction")) {
            this.exit();
        }
    }

    public void chargerImages() {
        this.imageArduino = this.loadImage("arduinosmall.png");
        this.imageCommentGratter = this.loadImage("commentgratter.png");
        this.imageCourbe = this.loadImage("courbe2.png");
        this.imageCourbeZero = this.loadImage("courbezero.png");
        this.imageReglage = this.loadImage("reglage.png");
    }

    public void mesure() {
        int i;
        this.boutonRefaireReglage.represente();
        this.strokeWeight(5.0f);
        this.fill(0.0f, 0.0f, 0.0f);
        this.rect(250.0f, 250.0f, 718.0f, 272.0f);
        this.rect(670.0f, 100.0f, 300.0f, 127.0f);
        this.strokeWeight(1.0f);
        this.tint(150, 255.0f);
        this.image(this.imageCommentGratter, 670.0f, 100.0f);
        this.tint(255, 255.0f);
        this.fill(0.0f, 100.0f, 100.0f);
        this.ellipse(250.0f, 50.0f, 50.0f, 50.0f);
        this.fill(100.0f, 100.0f, 100.0f);
        this.textFont(this.font25);
        this.text("1", 242.0f, 58.0f);
        this.textSize(25.0f);
        this.text("R\u00e9glage acquis", 285.0f, 58.0f);
        this.fill(0.0f, 200.0f, 200.0f);
        this.ellipse(250.0f, 120.0f, 50.0f, 50.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.textFont(this.font25);
        this.text("2", 242.0f, 128.0f);
        this.textFont(this.font25);
        this.text("Mesures", 285.0f, 128.0f);
        this.textFont(this.font12);
        this.fill(200.0f, 200.0f, 200.0f);
        this.text("*   Bien maintenir le capteur avec votre index.\n\n*   Gratter le fil mod\u00e9rement entre le pot et le capteur. \n\n", 285.0f, 160.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.textFont(this.font20);
        if (this.periode == 0.0f) {
            this.image(this.imageCourbeZero, 250.0f, 250.0f);
            this.text("En attente...", 650.0f, 280.0f);
        } else {
            this.image(this.imageCourbe, 250.0f, 250.0f);
            this.text(String.valueOf(guitayourt_processing.nfc((float)this.periode, (int)2)) + " ms", 650.0f, 280.0f);
            if (this.periode > 1000.0f && this.periode != 0.0f) {
                this.fill(220.0f, 100.0f, 0.0f);
                this.textFont(this.font15);
                this.text("La valeur est vraiment trop grande \net ne sera pas retenue", 710.0f, 310.0f);
            }
        }
        if ((long)this.millis() - this.raz > 3000L && this.periode != 0.0f) {
            i = 0;
            while (i < 10) {
                if (this.periode < 1000.0f) {
                    if (this.tableauMesure[i] == 0.0f) {
                        this.tableauMesure[i] = this.periode;
                        break;
                    }
                    if (i == 9) {
                        this.tableauMesure = guitayourt_processing.subset((float[])this.tableauMesure, (int)1);
                        this.tableauMesure = guitayourt_processing.append((float[])this.tableauMesure, (float)this.periode);
                    }
                }
                ++i;
            }
            this.periode = 0.0f;
        }
        this.fill(100.0f, 100.0f, 100.0f);
        this.textFont(this.font10);
        this.text("Cette courbe est une image \nmais elle provient de mesures r\u00e9elles \neffectu\u00e9es avec un oscillospe \net avec le m\u00eame dispositif.", 285.0f, 260.0f);
        this.fill(100);
        this.stroke(0);
        i = 0;
        while (i < 11) {
            this.rect(245 + i * 65, 535.0f, 65.0f, 50.0f);
            ++i;
        }
        this.fill(255);
        this.textFont(this.font12);
        this.text("Mesures  \n  (ms)  ", 255.0f, 560.0f);
        this.textFont(this.font15);
        i = 0;
        while (i < 10) {
            if (this.tableauMesure[i] == 0.0f) {
                this.text("--", 330 + i * 65, 560.0f);
            } else {
                this.text(guitayourt_processing.nfc((float)this.tableauMesure[i], (int)2), 330 + i * 65, 560.0f);
            }
            ++i;
        }
        int c = 0;
        while (c < 10) {
            if (this.mouseX > 310 + c * 65 && this.mouseX < 375 + c * 65 && this.mouseY > 535 && this.mouseY < 585) {
                this.fill(255.0f, 0.0f, 0.0f);
                this.rect(310 + c * 65, 575.0f, 65.0f, 10.0f);
            }
            ++c;
        }
        if (this.mouseX > 310 && this.mouseX < 960 && this.mouseY > 535 && this.mouseY < 585) {
            this.cursor(12);
        } else {
            this.cursor(0);
        }
        this.fill(100.0f, 100.0f, 100.0f);
        this.textFont(this.font10);
        this.text("En cliquant sur une mesure, vous pouvez la supprimer si vous la jugez erron\u00e9e.", 312.0f, 600.0f);
    }

    public void mousePressed() {
        if (this.etape == 5) {
            int c = 0;
            while (c < 10) {
                if (this.mouseX > 310 + c * 65 && this.mouseX < 375 + c * 65 && this.mouseY > 535 && this.mouseY < 585 && this.tableauMesure[c] != 0.0f) {
                    this.tableauMesure[c] = 0.0f;
                }
                ++c;
            }
        }
    }

    public void pbConnexion() {
        this.fill(255.0f, 80.0f, 0.0f);
        this.textFont(this.font25);
        this.text("Probl\u00e8me de connexion \navec la carte Arduino !", 175.0f, 50.0f);
        this.fill(150.0f, 150.0f, 150.0f);
        this.textFont(this.font15);
        this.text("- V\u00e9rifier qu'il n'y a QUE la carte arduino de branch\u00e9e sur l'ordinateur.\n\n- Fermer ce logiciel \n\n- D\u00e9brancher puis brancher \u00e0 nouveau la carte Arduino.\n\n- Relancer ce logiciel.\n\n\n\n- Si le probl\u00e8me persiste, revoir pr\u00e9cisement la proc\u00e9dure \ndans la partie fabrication du Guitayourt sur www.sciencesmania.com", 200.0f, 150.0f);
    }

    public void reglage() {
        this.fill(0.0f, 200.0f, 200.0f);
        this.ellipse(250.0f, 50.0f, 50.0f, 50.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.textFont(this.font25);
        this.text("1", 242.0f, 58.0f);
        this.textSize(25.0f);
        this.text("R\u00e9glage", 285.0f, 58.0f);
        this.fill(100.0f, 200.0f, 255.0f);
        this.textFont(this.font12);
        this.text("Il s'agit de positionner correctement le capteur par rapport au fil \nafin d'obtenir des signaux exploitables.\n", 285.0f, 100.0f);
        this.fill(200.0f, 200.0f, 200.0f);
        this.text("*   Maintenir le capteur avec votre index.\n\n*   Tourner la molette afin de positionner le fil \u00e0 peu pr\u00e8s au milieu de la del. \nLa tension doit \u00eatre \u00e9lev\u00e9e.\n\n*   Agir de nouveau sur la molette doucement afin d'atteindre le seuil de tension n\u00e9cessaire. \nLa tension doit baisser et le fil doit \u00eatre d\u00e9cal\u00e9 par rapport \u00e0 la del rouge. ", 285.0f, 145.0f);
        this.fill(200.0f, 150.0f, 100.0f);
        this.textFont(this.font12);
        this.text("Le capteur mesure une tension en fonction de la lumi\u00e8re re\u00e7ue. \nUne luminosit\u00e9 ambiante tr\u00e8s changeante peut perturber la mesure.", 285.0f, 600.0f);
        this.stroke(0.0f, 0.0f, 0.0f);
        this.strokeWeight(5.0f);
        this.rect(285.0f, 280.0f, 200.0f, 259.0f);
        this.strokeWeight(1.0f);
        this.image(this.imageReglage, 285.0f, 280.0f);
        this.stroke(200.0f, 200.0f, 200.0f);
        this.line(320.0f, 400.0f, 320.0f, 585.0f);
        this.line(300.0f, 585.0f, 340.0f, 585.0f);
        this.line(317.0f, 405.0f, 320.0f, 400.0f);
        this.line(322.0f, 405.0f, 320.0f, 400.0f);
        float histo = this.tension * 259 / 1024;
        if (this.tension > 80) {
            this.fill(255.0f, 0.0f, 0.0f);
        } else {
            this.boutonOkReglage.represente();
            this.fill(0.0f, 255.0f, 0.0f);
        }
        this.stroke(0.0f, 0.0f, 0.0f);
        this.rect(520.0f, 539.0f - histo, 30.0f, histo);
        this.fill(200);
        this.textFont(this.font12);
        this.text(String.valueOf(guitayourt_processing.nfc((float)((float)this.tension * 5.0f / 1023.0f), (int)2)) + " V", 520.0f, 559.0f);
        this.stroke(200.0f, 200.0f, 200.0f);
        this.strokeWeight(1.0f);
        this.fill(200.0f, 150.0f, 100.0f);
        this.textFont(this.font12);
        this.text("Seuil", 570.0f, 524.0f);
        this.line(510.0f, 519.0f, 560.0f, 519.0f);
    }

    public void connexionArduino() {
        if (Serial.list().length > 0) {
            this.maConnexionArduino = new Serial((PApplet)this, Serial.list()[0], 115200);
            this.maConnexionArduino.bufferUntil(13);
            this.etatConnexionArduino = 1;
        } else {
            this.etatConnexionArduino = -1;
        }
    }

    public void serialEvent(Serial p) {
        String messageRecu;
        if (this.etatConnexionArduino == 2 && this.etape == 1) {
            messageRecu = guitayourt_processing.trim((String)this.maConnexionArduino.readStringUntil(13));
            this.tension = PApplet.parseInt((String)messageRecu);
        }
        if (this.etatConnexionArduino == 1 && (messageRecu = guitayourt_processing.trim((String)this.maConnexionArduino.readStringUntil(13))).equals("g")) {
            this.etatConnexionArduino = 2;
        }
        if (this.etatConnexionArduino == 2 && this.etape == 3 && (messageRecu = guitayourt_processing.trim((String)this.maConnexionArduino.readStringUntil(13))).equals("m")) {
            this.etape = 4;
        }
        if (this.etatConnexionArduino == 2 && this.etape == 5) {
            messageRecu = guitayourt_processing.trim((String)this.maConnexionArduino.readStringUntil(13));
            this.periode = PApplet.parseFloat((String)messageRecu) / 1000.0f;
            this.raz = this.millis();
        }
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"guitayourt_processing"};
        if (passedArgs != null) {
            PApplet.main((String[])guitayourt_processing.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Bouton {
        int bx;
        int by;
        int bw;
        int bh;
        String btext;
        String bfonction;
        int bstyle;

        Bouton(int x, int y, int w, int h, String text, String fonction, int style) {
            this.bx = x;
            this.by = y;
            this.bw = w;
            this.bh = h;
            this.btext = text;
            this.bfonction = fonction;
            this.bstyle = style;
        }

        public void represente() {
            guitayourt_processing.this.rectMode(3);
            if (guitayourt_processing.this.mouseX > this.bx - this.bw / 2 && guitayourt_processing.this.mouseX < this.bx + this.bw / 2 && guitayourt_processing.this.mouseY > this.by - this.bh / 2 && guitayourt_processing.this.mouseY < this.by + this.bh / 2) {
                if (guitayourt_processing.this.mousePressed) {
                    guitayourt_processing.this.stroke(255);
                    guitayourt_processing.this.fill(1.0f, 1.0f, 1.0f);
                    guitayourt_processing.this.strokeWeight(1.0f);
                    guitayourt_processing.this.rect(this.bx, this.by, this.bw, this.bh, 5.0f);
                    guitayourt_processing.this.noStroke();
                } else {
                    guitayourt_processing.this.stroke(255);
                    guitayourt_processing.this.fill(67.0f, 181.0f, 73.0f);
                    guitayourt_processing.this.strokeWeight(1.0f);
                    guitayourt_processing.this.rect(this.bx, this.by, this.bw, this.bh, 5.0f);
                    guitayourt_processing.this.noStroke();
                }
            } else {
                if (this.bstyle == 1) {
                    guitayourt_processing.this.stroke(255);
                    guitayourt_processing.this.fill(116.0f, 116.0f, 116.0f);
                    guitayourt_processing.this.strokeWeight(1.0f);
                }
                if (this.bstyle == 2) {
                    guitayourt_processing.this.stroke(255);
                    guitayourt_processing.this.fill(150.0f, 50.0f, 50.0f);
                    guitayourt_processing.this.strokeWeight(1.0f);
                }
                guitayourt_processing.this.rect(this.bx, this.by, this.bw, this.bh, 5.0f);
                guitayourt_processing.this.noStroke();
            }
            guitayourt_processing.this.rectMode(0);
            guitayourt_processing.this.fill(255.0f, 255.0f, 255.0f);
            guitayourt_processing.this.textFont(guitayourt_processing.this.font12);
            guitayourt_processing.this.textAlign(3);
            guitayourt_processing.this.text(this.btext, this.bx, this.by + 6 - 2);
            guitayourt_processing.this.textAlign(0);
        }

        public String checkOver() {
            if (guitayourt_processing.this.mouseX > this.bx - this.bw / 2 && guitayourt_processing.this.mouseX < this.bx + this.bw / 2 && guitayourt_processing.this.mouseY > this.by - this.bh / 2 && guitayourt_processing.this.mouseY < this.by + this.bh / 2) {
                return this.bfonction;
            }
            return "";
        }
    }
}

