/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.serial.Serial;

public class centrifugeuse_processing
extends PApplet {
    Bouton boutonQuitter;
    Bouton boutonWeb;
    Bouton boutonCalibreBas;
    Bouton boutonCalibreHaut;
    Bouton boutonCapturer;
    PFont font20;
    PFont font12;
    PFont font15;
    PFont font10;
    PFont font25;
    int etape = 0;
    float[] tableauMesure = new float[0];
    int stopMesure = 0;
    float echelleTemps = 0.48f;
    int x1 = -2;
    int x2 = -2;
    int mesureOk = 0;
    PFont font;
    PImage imageArduino;
    Serial maConnexionArduino;
    int etatConnexionArduino = 0;
    String messageRecu;
    int tension;

    public void setup() {
        this.font10 = this.loadFont("Arial-BoldMT-10.vlw");
        this.font12 = this.loadFont("Arial-BoldMT-12.vlw");
        this.font15 = this.loadFont("Arial-BoldMT-15.vlw");
        this.font20 = this.loadFont("Arial-BoldMT-20.vlw");
        this.font25 = this.loadFont("Arial-BoldMT-25.vlw");
        this.chargerImages();
        this.boutonQuitter = new Bouton(75, 150, 60, 25, "Quitter", "quitterFonction", 1);
        this.boutonWeb = new Bouton(75, this.height - 13, 130, 25, "site", "webFonction", 2);
        this.boutonCalibreBas = new Bouton(270, 600, 180, 25, "Diminuer l'\u00e9chelle du temps", "calibreBasFonction", 1);
        this.boutonCalibreHaut = new Bouton(465, 600, 180, 25, "Augmenter l'\u00e9chelle du temps", "calibreHautFonction", 1);
        this.boutonCapturer = new Bouton(700, 600, 150, 25, "Capturer la courbe", "capturerFonction", 1);
        this.connexionArduino();
    }

    public void draw() {
        this.background(50);
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.fill(30);
        this.rect(0.0f, 0.0f, 150.0f, this.height);
        this.image(this.imageArduino, 20.0f, 20.0f);
        this.fill(200.0f, 200.0f, 200.0f);
        this.textFont(this.font20);
        this.text("        T.P.    \n Centrifugeuse", 10.0f, this.height / 2);
        this.fill(80.0f, 80.0f, 80.0f);
        this.textFont(this.font10);
        this.text(PApplet.parseInt((float)this.frameRate), 5.0f, 10.0f);
        this.boutonQuitter.represente();
        this.fill(100.0f, 100.0f, 100.0f);
        this.textFont(this.font10);
        this.text("Cyril Vallet (c) - 2020 \n www.sciencesmania.com", 5.0f, this.height - 18);
        if (this.etatConnexionArduino == -1) {
            this.pbConnexion();
        }
        if (this.etatConnexionArduino == 1) {
            this.fill(255.0f, 255.0f, 255.0f);
            this.textFont(this.font10);
            this.text("Connexion \u00e0 l'arduino ...", 25.0f, 105.0f);
            this.maConnexionArduino.write("g");
        }
        if (this.etatConnexionArduino == 2) {
            this.fill(0.0f, 255.0f, 150.0f);
            this.textFont(this.font10);
            this.text("Connect\u00e9", 25.0f, 105.0f);
            this.dessinerQuadrillage();
            this.boutonCalibreBas.represente();
            this.boutonCalibreHaut.represente();
            this.boutonCapturer.represente();
        }
        if (this.etatConnexionArduino == 2 && this.etape == 0) {
            this.maConnexionArduino.write(114);
            this.etape = 1;
        }
        if (this.etatConnexionArduino == 2 && this.etape == 1) {
            this.afficherDonnees();
        }
    }

    public void afficherDonnees() {
        if (this.tableauMesure.length > 299) {
            int i = 0;
            while (i < 299) {
                this.stroke(0.0f, 255.0f, 0.0f);
                this.line(2 * i + 180, 550.0f - this.tableauMesure[i] / 2.0f, 2 * (i + 1) + 180, 550.0f - this.tableauMesure[i + 1] / 2.0f);
                this.stroke(0.0f, 255.0f, 0.0f);
                this.strokeWeight(3.0f);
                this.point(2 * i + 180, 550.0f - this.tableauMesure[i] / 2.0f);
                this.strokeWeight(1.0f);
                ++i;
            }
            if (this.stopMesure == 0) {
                this.tableauMesure = centrifugeuse_processing.subset((float[])this.tableauMesure, (int)0, (int)0);
                if (this.echelleTemps == 0.03f) {
                    this.maConnexionArduino.write(114);
                }
                if (this.echelleTemps == 0.06f) {
                    this.maConnexionArduino.write(116);
                }
                if (this.echelleTemps == 0.12f) {
                    this.maConnexionArduino.write(117);
                }
                if (this.echelleTemps == 0.24f) {
                    this.maConnexionArduino.write(118);
                }
                if (this.echelleTemps == 0.48f) {
                    this.maConnexionArduino.write(119);
                }
            }
        }
        if (this.stopMesure == 1) {
            this.strokeWeight(0.0f);
            this.fill(170);
            this.textFont(this.font12);
            this.text("Cliquer dans le cadre pour \neffectuer une mesure de dur\u00e9e", 620.0f, 650.0f);
            this.strokeWeight(1.0f);
            this.stroke(255);
            this.line(this.x1, 25.0f, this.x1, 550.0f);
            this.line(this.x2, 25.0f, this.x2, 550.0f);
            this.fill(255);
            this.textFont(this.font15);
            if (this.x1 > 0 && this.x2 > 0) {
                this.strokeWeight(1.0f);
                this.stroke(255);
                this.line(this.x1, 30.0f, this.x2, 30.0f);
                int positionPeriode = 0;
                if (this.x1 > this.x2) {
                    positionPeriode = this.x2 + 20;
                    this.line(this.x1, 30.0f, this.x1 - 5, 25.0f);
                    this.line(this.x1, 30.0f, this.x1 - 5, 35.0f);
                    this.line(this.x2, 30.0f, this.x2 + 5, 25.0f);
                    this.line(this.x2, 30.0f, this.x2 + 5, 35.0f);
                } else {
                    positionPeriode = this.x1 + 20;
                    this.line(this.x2, 30.0f, this.x2 - 5, 25.0f);
                    this.line(this.x2, 30.0f, this.x2 - 5, 35.0f);
                    this.line(this.x1, 30.0f, this.x1 + 5, 25.0f);
                    this.line(this.x1, 30.0f, this.x1 + 5, 35.0f);
                }
                this.strokeWeight(0.0f);
                this.stroke(255);
                if (this.echelleTemps > 0.12f) {
                    this.text(centrifugeuse_processing.nfc((float)((float)centrifugeuse_processing.abs((int)(this.x2 - this.x1)) * this.echelleTemps / 2.0f), (int)2), positionPeriode, 20.0f);
                } else {
                    this.text(centrifugeuse_processing.nfc((float)((float)centrifugeuse_processing.abs((int)(this.x2 - this.x1)) * this.echelleTemps / 2.0f), (int)2), positionPeriode, 20.0f);
                }
                this.text("ms", positionPeriode + 45, 20.0f);
                this.fill(100);
                this.textFont(this.font10);
                float incertitude = 0.0f;
                if (this.echelleTemps == 0.03f) {
                    incertitude = 0.04f;
                }
                if (this.echelleTemps == 0.06f) {
                    incertitude = 0.08f;
                }
                if (this.echelleTemps == 0.12f) {
                    incertitude = 0.15f;
                }
                if (this.echelleTemps == 0.24f) {
                    incertitude = 0.3f;
                }
                if (this.echelleTemps == 0.48f) {
                    incertitude = 0.5f;
                }
                this.text("Incertitude : \n+/-  " + incertitude + "  ms", 800.0f, 20.0f);
            }
        }
    }

    public void mousePressed() {
        if (this.mouseX > 179 && this.mouseX < 779 && this.mouseY > 38 && this.mouseY < 550) {
            if (this.mesureOk == 0) {
                this.x1 = this.mouseX;
                this.mesureOk = 1;
            }
            if (this.mesureOk == 2) {
                this.x2 = this.mouseX;
                this.mesureOk = 3;
            }
        }
    }

    public void mouseReleased() {
        String quelleFonction;
        if (this.stopMesure == 1) {
            if (this.mesureOk == 1) {
                this.mesureOk = 2;
            }
            if (this.mesureOk == 3) {
                this.mesureOk = 0;
            }
        }
        if ((quelleFonction = this.boutonWeb.checkOver()).equals("webFonction")) {
            this.link("https://www.sciencesmania.com");
        }
        if ((quelleFonction = this.boutonQuitter.checkOver()).equals("quitterFonction")) {
            this.exit();
        }
        if ((quelleFonction = this.boutonCalibreBas.checkOver()).equals("calibreBasFonction") && this.stopMesure == 0) {
            this.echelleTemps *= 2.0f;
            if (this.echelleTemps > 0.48f) {
                this.echelleTemps = 0.48f;
            }
            if (this.echelleTemps == 0.03f) {
                this.maConnexionArduino.write(114);
            }
            if (this.echelleTemps == 0.06f) {
                this.maConnexionArduino.write(116);
            }
            if (this.echelleTemps == 0.12f) {
                this.maConnexionArduino.write(117);
            }
            if (this.echelleTemps == 0.24f) {
                this.maConnexionArduino.write(118);
            }
            if (this.echelleTemps == 0.48f) {
                this.maConnexionArduino.write(119);
            }
        }
        if ((quelleFonction = this.boutonCalibreHaut.checkOver()).equals("calibreHautFonction") && this.stopMesure == 0) {
            this.echelleTemps /= 2.0f;
            if (this.echelleTemps < 0.03f) {
                this.echelleTemps = 0.03f;
            }
            if (this.echelleTemps == 0.03f) {
                this.maConnexionArduino.write(114);
            }
            if (this.echelleTemps == 0.06f) {
                this.maConnexionArduino.write(116);
            }
            if (this.echelleTemps == 0.12f) {
                this.maConnexionArduino.write(117);
            }
            if (this.echelleTemps == 0.24f) {
                this.maConnexionArduino.write(118);
            }
            if (this.echelleTemps == 0.48f) {
                this.maConnexionArduino.write(119);
            }
        }
        if ((quelleFonction = this.boutonCapturer.checkOver()).equals("capturerFonction")) {
            if (this.stopMesure == 0) {
                this.stopMesure = 1;
                this.boutonCapturer.btext = "Relancer les mesures";
                this.x1 = -2;
                this.x2 = -2;
            } else {
                this.stopMesure = 0;
                this.boutonCapturer.btext = "Capturer la courbe";
            }
        }
    }

    public void dessinerQuadrillage() {
        int nbPixel;
        this.stroke(20);
        this.strokeWeight(1.0f);
        this.fill(60);
        this.textSize(10.0f);
        this.rect(179.0f, 38.0f, 600.0f, 512.0f);
        int i = 0;
        while (i < 5) {
            this.stroke(20, 50.0f);
            this.strokeWeight(1.0f);
            this.line(175.0f, 550 - 102 * i, 775.0f, 550 - 102 * i);
            this.fill(100);
            this.text(String.valueOf(i) + " V", 160.0f, 550 - 102 * i);
            ++i;
        }
        int grad = 1;
        int v = nbPixel = PApplet.parseInt((float)(2.0f / this.echelleTemps));
        while (nbPixel < 600) {
            this.stroke(20, 50.0f);
            this.strokeWeight(1.0f);
            this.line(180 + nbPixel, 38.0f, 180 + nbPixel, 550.0f);
            if (this.echelleTemps > 0.06f) {
                if (grad % 10 == 0) {
                    this.text(grad, 180 + nbPixel, 560.0f);
                }
            } else {
                this.text(grad, 180 + nbPixel, 560.0f);
            }
            ++grad;
            nbPixel = v + nbPixel;
        }
        this.strokeWeight(0.0f);
        this.fill(255);
        this.textSize(10.0f);
        this.text(" ms", 800.0f, 560.0f);
    }

    public void chargerImages() {
        this.imageArduino = this.loadImage("arduinosmall.png");
    }

    public void pbConnexion() {
        this.fill(255.0f, 80.0f, 0.0f);
        this.textFont(this.font25);
        this.text("Probl\u00e8me de connexion \navec la carte Arduino !", 175.0f, 50.0f);
        this.fill(150.0f, 150.0f, 150.0f);
        this.textFont(this.font15);
        this.text("- V\u00e9rifier qu'il n'y a QUE la carte arduino de branch\u00e9e sur l'ordinateur.\n\n- Fermer ce logiciel \n\n- D\u00e9brancher puis brancher \u00e0 nouveau la carte Arduino.\n\n- Relancer ce logiciel.\n\n\n\n- Si le probl\u00e8me persiste, revoir pr\u00e9cisement la proc\u00e9dure \ndans la partie fabrication du Guitayourt sur www.sciencesmania.com", 200.0f, 150.0f);
    }

    public void connexionArduino() {
        if (Serial.list().length > 0) {
            this.maConnexionArduino = new Serial((PApplet)this, Serial.list()[0], 2000000);
            this.maConnexionArduino.bufferUntil(13);
            this.etatConnexionArduino = 1;
        } else {
            this.etatConnexionArduino = -1;
        }
    }

    public void serialEvent(Serial p) {
        String messageRecu;
        if (this.etatConnexionArduino == 1 && (messageRecu = centrifugeuse_processing.trim((String)this.maConnexionArduino.readStringUntil(13))).equals("g")) {
            this.etatConnexionArduino = 2;
        }
        if (this.etatConnexionArduino == 2 && this.etape == 1) {
            messageRecu = centrifugeuse_processing.trim((String)this.maConnexionArduino.readStringUntil(13));
            int tension = PApplet.parseInt((String)messageRecu);
            this.tableauMesure = centrifugeuse_processing.append((float[])this.tableauMesure, (float)tension);
        }
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"centrifugeuse_processing"};
        if (passedArgs != null) {
            PApplet.main((String[])centrifugeuse_processing.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Bouton {
        int bx;
        int by;
        int bw;
        int bh;
        String btext;
        String bfonction;
        int bstyle;

        Bouton(int x, int y, int w, int h, String text, String fonction, int style) {
            this.bx = x;
            this.by = y;
            this.bw = w;
            this.bh = h;
            this.btext = text;
            this.bfonction = fonction;
            this.bstyle = style;
        }

        public void represente() {
            centrifugeuse_processing.this.rectMode(3);
            if (centrifugeuse_processing.this.mouseX > this.bx - this.bw / 2 && centrifugeuse_processing.this.mouseX < this.bx + this.bw / 2 && centrifugeuse_processing.this.mouseY > this.by - this.bh / 2 && centrifugeuse_processing.this.mouseY < this.by + this.bh / 2) {
                if (centrifugeuse_processing.this.mousePressed) {
                    centrifugeuse_processing.this.stroke(255);
                    centrifugeuse_processing.this.fill(1.0f, 1.0f, 1.0f);
                    centrifugeuse_processing.this.strokeWeight(1.0f);
                    centrifugeuse_processing.this.rect(this.bx, this.by, this.bw, this.bh, 5.0f);
                    centrifugeuse_processing.this.noStroke();
                } else {
                    centrifugeuse_processing.this.stroke(255);
                    centrifugeuse_processing.this.fill(67.0f, 181.0f, 73.0f);
                    centrifugeuse_processing.this.strokeWeight(1.0f);
                    centrifugeuse_processing.this.rect(this.bx, this.by, this.bw, this.bh, 5.0f);
                    centrifugeuse_processing.this.noStroke();
                }
            } else {
                if (this.bstyle == 1) {
                    centrifugeuse_processing.this.stroke(255);
                    centrifugeuse_processing.this.fill(116.0f, 116.0f, 116.0f);
                    centrifugeuse_processing.this.strokeWeight(1.0f);
                }
                if (this.bstyle == 2) {
                    centrifugeuse_processing.this.stroke(255);
                    centrifugeuse_processing.this.fill(150.0f, 50.0f, 50.0f);
                    centrifugeuse_processing.this.strokeWeight(1.0f);
                }
                centrifugeuse_processing.this.rect(this.bx, this.by, this.bw, this.bh, 5.0f);
                centrifugeuse_processing.this.noStroke();
            }
            centrifugeuse_processing.this.rectMode(0);
            centrifugeuse_processing.this.fill(255.0f, 255.0f, 255.0f);
            centrifugeuse_processing.this.textFont(centrifugeuse_processing.this.font12);
            centrifugeuse_processing.this.textAlign(3);
            centrifugeuse_processing.this.text(this.btext, this.bx, this.by + 6 - 2);
            centrifugeuse_processing.this.textAlign(0);
        }

        public String checkOver() {
            if (centrifugeuse_processing.this.mouseX > this.bx - this.bw / 2 && centrifugeuse_processing.this.mouseX < this.bx + this.bw / 2 && centrifugeuse_processing.this.mouseY > this.by - this.bh / 2 && centrifugeuse_processing.this.mouseY < this.by + this.bh / 2) {
                return this.bfonction;
            }
            return "";
        }
    }
}

