/**********************************************
Cyril Vallet - 2020 - www.sciencesmania.com   
Si vous modifiez/copier ce code merci d'indiquer
la provenance en mettant un lien vers mon site  
 
Pour les montages et l'électronique voir mon site
www.sciencesmania.com  

**************************************
Ce programme permet d'exploiter le montage du minuteur 
https://www.sciencesmania.com/un-petit-minuteur
***************************************/

// gestion des sorties numériques
int pinHp = 6; 
int pinDelRouge = 3;
int pinDelVerte = 2;
int pinBouton = 4;
int etat_bouton =0;

// gestion du temps
long timer;
int duree = 31;  // en secondes

// gestion du minuteur
int go=0;

// *************************
// initilations du programme
//**************************
void setup() {

 // INITIALISATION des sorties
 // le haut parleur
 pinMode(pinHp, OUTPUT);
 // les dels
 pinMode(pinDelRouge, OUTPUT);
 pinMode(pinDelVerte, OUTPUT);
 // le bouton
  pinMode(pinBouton, INPUT);

 // allumer la Del rouge 
 digitalWrite(pinDelRouge, HIGH); 
}


// *************************
// programme qui boucle
//**************************
void loop() {

  // si le chrono est lancé
  if (go ==1){
    // si la durée est dépassée
    if ((millis()- timer) > duree*1000){

       // trois bips successifs
       tone(pinHp, 2000,100);
       delay(200);
       tone(pinHp, 2000,100);
        delay(200);
       tone(pinHp, 3000,1000);

       digitalWrite(pinDelVerte, LOW); // éteindre la del Verte
       digitalWrite(pinDelRouge, HIGH); // allumer la del Rouge

      // arrêter le minuteur
      go =0;
    }
      
  }
  
  // *************************
  //  GESTION DU BOUTON
  //*************************

  // si on appuie sur le bouton 
  if (digitalRead(pinBouton) == HIGH && etat_bouton == 0)
  {
    if (go ==0){
      
       timer =millis(); // lance le chrono
     
       digitalWrite(pinDelVerte, HIGH); // allumer la del verte
       digitalWrite(pinDelRouge, LOW); // eteint la del rouge
       tone(pinHp, 500,200); // un bip pour signaler le début du minuteur

       go = 1;  // le minuteur est lancé
       
     } else { // permet d'arrêter le minuteur si départ loupé

      go =0;
      digitalWrite(pinDelVerte, LOW); // éteindre la del Verte
      digitalWrite(pinDelRouge, HIGH); // allumer la del Rouge
      tone(pinHp, 500,200);
      
     }

    etat_bouton =1;
  
  }

  // si on relache le bouton
   if (digitalRead(pinBouton) == LOW && etat_bouton ==1 ) 
    {
      etat_bouton =0; 
   }
   
} // fin du LOOP
