// ****************************
//  CYRIL VALLET 2017 
//  
//  Merci de visiter mon site et d'y laisser un petit commentaire
// ca fait toujours plaisir.
// ***************************


//**********************************
//             LIBRAIRIES
//**********************************

// pour la communication  I2C
#include <Wire.h>       
// adresses binaires des puces PCF8574
const byte adresse_1 = 0b00100000;
const byte adresse_2 = 0b00100001;

// variables pour les animations
long quelleAnimation = 1;
int vitesse = random(50,300);

// si on veut les animations ou non via le bouton 
// pas d'animation au début pour vérif del
volatile byte animOk = 0; // si on veut les animations ou non via le bouton 


// pour le defilement du temps : une lettre afficher par minute passée
volatile byte timeOk = 0; // si on veut les animations ou non via le bouton 


int lettre=0;
long tempsPasse =-1;
//**********************************
//             SETUP
//**********************************
void setup() {

  // créer la liaison I2C pour les puces PCF8574
  Wire.begin();
  delay(10);

  // pour le bouton afin de choisir le mode éclairer ou avec les animations
  attachInterrupt(digitalPinToInterrupt(2), boutonAnim, FALLING);

// laisser l'animation qui 
  attachInterrupt(digitalPinToInterrupt(3), boutonTime, FALLING);
  
  // pas de fade au départ
  analogWrite(9, 255);
  analogWrite(10, 255);

  // allume toutes les dels au démarrage pour voir leur état
  Wire.beginTransmission(adresse_1); Wire.write(0b00000000); Wire.endTransmission();
  Wire.beginTransmission(adresse_2); Wire.write(0b00000000); Wire.endTransmission();

  // _________pour le DEBUG_________
  Serial.begin(9600);

  pinMode(2, INPUT);
  pinMode(3, INPUT);

}


//**********************************
//            LOOP
//**********************************
void loop() {

 if (animOk ==1) {

  
   switch(quelleAnimation){
    case 1: anim_1(); //toutes les dels clignontent en même temps  X4
      break;
    case 2: anim_2(); // une del s'allume de manière aléatoire
      break;
    case 3: anim_3(); // CHENILLARD avec une DEL allumée
      break;
    case 4: anim_4(); // CHENILLARD avec unee DEL allumée mais en sens inverse
      break;
    case 5: anim_5(); // CHENILLARD avec SEULE DEL éteinte
      break;
    case 6: anim_6(); // CHENILLARD avec SEULE DEL éteinte mais en sens inverse
      break;
    case 7: anim_7(); // DEL fixent pendant quelques secondes
      break;
    case 8: anim_8(); // une del s'allume de manière aléatoire mais avec le FADE
      break;
    case 9: anim_9 (); // FADE alterné Physique / chimie
      break;
    case 10: anim_10(); // FADE avec toutes les DEL
      break;  
    }
    choixAnimation();
    
   } 
 

  if (timeOk == 1) {
    chronoLettre();  // lance l'animation 1 lettre par minute successivement 
  }
 

}


//**********************************
//            FONCTIONS
//**********************************



void boutonAnim() {

     animOk = 1; 


}

void boutonTime() {
  
  animOk = 0; 
  
}
